<?php
use Ratchet\Server\IoServer;
use Ratchet\Http\HttpServer;
use Ratchet\WebSocket\WsServer;
use React\EventLoop\Factory;
use React\Socket\Server;
use React\Socket\SecureServer;

use MyApp\Desc;
use MyApp\Init;

require 'vendor/autoload.php';

$sslCertPath = '/var/cpanel/ssl/apache_tls/ocpp.alpha.plugdrive.app/combined';

$loop = Factory::create();
$server = new Server('0.0.0.0:2060', $loop);

try {
    $secureServer = new SecureServer($server, $loop, [
        'local_cert' => $sslCertPath, // Use combined certificate and key
        'local_pk' => $sslCertPath,   // Use the same combined file for the key
        'verify_peer' => false,
        'allow_self_signed' => true,
        'session_cache_server' => true,
        'session_cache_limit' => 512, // Cache up to 512 sessions
        'session_cache_size' => 1024 * 1024, // 1MB cache size
        'session_cache_timeout' => 3600 // 1 hour timeout
    ]);
} catch (Exception $e) {
    die("Failed to create SecureServer: " . $e->getMessage() . "\n");
}
$socket = new Desc();
$httpServer = new HttpServer(new WsServer($socket));

$ioServer = new IoServer($httpServer, $secureServer, $loop);

// When the ws connection is active, start a timer to check and send commands to the station
$ioServer->loop->addPeriodicTimer(5, function () use ($socket) {
    foreach ($socket->clients as $client) {
        $init = new Init();
        $send = $init->SetCommand($socket->ReturnidTag($client));
        if ($send && $send['idTag'] === $socket->ReturnidTag($client)) {
            $init->UpUserCommand($socket->ReturnidTag($client), $send['user_id']);
            echo 'CS - user_id - ' . $send['user_id'] . ' - ' . $socket->ReturnidTag($client) . ' ' . date('H:i:s') . ' ' . $send['text'] . PHP_EOL . PHP_EOL;
            $client->send($send['text']);
            $init->up_command($send['text'], $socket->ReturnidTag($client));
        }
    }
});

// Start ws server
$ioServer->run();