<?php
namespace MyApp;

class Configuration
{
    private $db;

    public function __construct($db)
    {
        $this->db = $db;
    }

    public function setConfigurationFromCharger($idTag, $data)
    {
        if (!isset($data[2]->configurationKey) || !is_array($data[2]->configurationKey)) {
            return;
        }

        $now = date('Y-m-d H:i:s');

        foreach ($data[2]->configurationKey as $config) {
            $key = $config->key ?? null;
            $value = $config->value ?? null;
            $readOnly = isset($config->readonly) ? ($config->readonly ? 1 : 0) : 0;

            if (!empty($key)) {
                if ($this->configExists($idTag, $key)) {
                    $this->updateConfig($idTag, $key, $value, $readOnly, $now);
                } else {
                    $this->insertConfig($idTag, $key, $value, $readOnly, $now);
                }
            }
        }
    }

    private function configExists($idTag, $key)
    {
        $row = $this->db->row("
            SELECT id FROM my_charger_configuration
            WHERE idTag = '{$idTag}' AND `key` = '{$key}'
        ");
        return $row ? true : false;
    }

    private function updateConfig($idTag, $key, $value, $readOnly, $now)
    {
        $this->db->query("
            UPDATE my_charger_configuration
            SET value = '{$value}', read_only = '{$readOnly}', updated_at = '{$now}'
            WHERE idTag = '{$idTag}' AND `key` = '{$key}'
        ");
    }

    private function insertConfig($idTag, $key, $value, $readOnly, $now)
    {
        $this->db->query("
            INSERT INTO my_charger_configuration
            (`idTag`, `key`, `value`, `read_only`, `created_at`, `updated_at`)
            VALUES
            ('{$idTag}', '{$key}', '{$value}', '{$readOnly}', '{$now}', '{$now}')
        ");
    }
}
